// @name "Playlist Manager (04.09.2013)"
// @author "NADIR1"

var np_minH = 0;

// Playlist

var lm = 0;
var rm = 0;
var tm = np_minH;
var bm = 0;

var default_text_state = 0;

//text colors
var text_normal_color = blendColors(g_textcolor, g_backcolor, 0.0);
var text_hover_color = g_textcolor;
var text_down_color = g_textcolor;

var text_selected_normal_color = g_textcolor;
var text_selected_hover_color = g_textcolor;
var text_selected_down_color = g_textcolor;

var text_playing_normal_color = g_textcolor;
var text_playing_hover_color = g_textcolor;
var text_playing_down_color = g_textcolor;

//item colors
var item_normal_color = setAlpha(g_textcolor, 0);
var item_hover_color = setAlpha(g_textcolor, 15);
var item_selected_color = setAlpha(g_textcolor, 10);

var item_selected_normal_color = setAlpha(g_textcolor, 20);
var item_selected_hover_color = setAlpha(g_textcolor, 20);
var item_selected_down_color = setAlpha(g_textcolor, 10);

var item_playing_normal_color = setAlpha(g_textcolor, 20);
var item_playing_hover_color = setAlpha(g_textcolor, 20);
var item_playing_down_color = setAlpha(g_textcolor, 5);

// scrollbar colors
var vs_normal_color = blendColors(g_textcolor, g_backcolor, 0.9);
var vs_hover_color = blendColors(g_textcolor, g_backcolor, 0.8);
var vs_down_color = blendColors(g_textcolor, g_backcolor, 0.93);

var text_font = gdi.Font("Segoe UI", 14, FontStyles.Regular);
var text_font_selected = gdi.Font("Segoe UI", 14, FontStyles.Bold);
var text_font_playing = gdi.Font("Segoe UI", 14, FontStyles.Regular);
var text_font_big = gdi.Font("Segoe UI", 16, FontStyles.Regular);
var rbtnDown;
var row_height = 50;
var itemspace = 0;
var hbtn, dbtn;
var dragitem;
var hoveritem;
var destination = -1;
var Items = [];
var Y_OFFSET = 0;
var sum_height = 0;
var DefaultTextItem;

var slider_hover;
var slider_y_rel;
var slider_drag;
var dragitem_y_rel;

var scrollW = 10;
var scrollH = 30;
var scrollpos;
var scrollmax;
var ratio;
var NeedScrollbar;

var mouse_x;
var mouse_y;
var direction;
var dragging = false;

var cid;
var context_hover = false;

var ButtonAnimationTimerID;
var ScrollTimerID;
var MaxRange;

// WSH drag and drop globals
var g_handles = null;

var PlaylistIcon;

function Button(x, y, width, height, c_width, c_height, img, fn_onclick, tiptext) {
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
	this.c_width = c_width;
	this.c_height = c_height;
	this.tiptext = tiptext;
	this.NeedRefresh = 0;
	this.img = img;
	this.oldstate = 0; // 0=normal, 1=hover, 2=down.
	this.state = 0;
	this.opacity = 0; // Opacity of new state image.
	this.step = 0;

	this.OnClick = fn_onclick;

	this.ChangeState = function (s) {
		this.oldstate = this.state;
		this.state = s;
		this.opacity = 0;
		this.NeedRefresh = 1;
		switch (s) {
		case 0:
			this.step = 40; // Step of changing to normal state.
			break;
		case 1:
			this.step = 75; // hover state.
			break;
		case 2:
			this.step = 85; // down state.
			break;
		}

		if (!ButtonAnimationTimerID) // start animation
			ButtonAnimationTimer.Start();
	}

	this.isXYok = function (x2, y2) {
		return (x2 >= this.x && y2 >= this.y + Y_OFFSET && x2 <= this.x + width && y2 <= this.y + Y_OFFSET + height) ? true : false;
	}

	this.Draw = function (x2, y2, gr) {
		if (this.opacity < 255)
			this.img && gr.DrawImage(this.img, x2, y2, width, height, this.oldstate * c_width, 0, c_width, c_height, 0, 255);
		if (this.opacity)
			this.img && gr.DrawImage(this.img, x2, y2, width, height, this.state * c_width, 0, c_width, c_height, 0, this.opacity);
	}

	this.RefreshOpacity = function (fn) {
		if (this.opacity < 255)
			this.opacity = Math.min(this.opacity + this.step, 255);
		else {
			this.oldstate = this.state;
			this.opacity = 0;
			this.NeedRefresh = 0;
		}
	}
}

function GetCoordinates() {
	for (var i = 0; i < Items.length; i++) {
		Items[i].width = NeedScrollbar ? ww - lm - rm - scrollW : ww - lm - rm;
		Items[i].closebtn.x = Items[i].x + Items[i].width - 30;
	}

	// Calculate the max range of buttons, for increasing refresh speed.
	MaxRange = {
		x : Items.length > 0 ? Items[0].closebtn.x : 0,
		y : Items.length > 0 ? Items[0].closebtn.y + Y_OFFSET : 0,
		width : Items.length > 0 ? Items[0].closebtn.width : 0,
		height : Items.length > 0 ? Items[0].closebtn.height : 0
	}

	for (var i = 1; i < Items.length; i++) {
		MaxRange.x = Math.min(Items[i].closebtn.x, MaxRange.x);
		MaxRange.y = Math.min(Items[i].closebtn.y + Y_OFFSET, MaxRange.y);
		MaxRange.width = Math.max(Items[i].closebtn.x + Items[i].closebtn.width - MaxRange.x, MaxRange.width);
		MaxRange.height = Math.max(Items[i].closebtn.y + Y_OFFSET + Items[i].closebtn.height - MaxRange.y, MaxRange.height);
	}
}

function InitButtons() {
	var g;

	img_close = gdi.CreateImage(row_height / 2 * 3, row_height / 2);
	g = img_close.GetGraphics();
	g.DrawImage(clear_off, 0, 0, clear_off.Width, clear_off.Height, 1, 1, clear_off.Width, clear_off.Height);
	g.DrawImage(clear_ov, row_height / 2, 0, clear_off.Width, clear_off.Height, 1, 1, clear_off.Width, clear_off.Height);
	g.DrawImage(clear_on, row_height, 0, clear_off.Width, clear_off.Height, 1, 1, clear_off.Width, clear_off.Height);
	img_close.ReleaseGraphics(g);
}

function Item(x, y, width, height, name, count, id) {
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
	this.name = name;

	this.count = (count > 0 ? count + (count > 1 ? " " : " ") : "б");

	this.id = id;
	this.state = 0;

	this.closebtn = new Button(this.x + this.width, Math.round(this.y + row_height / 4), Math.round(row_height / 2), Math.round(row_height / 2), Math.round(row_height / 2), Math.round(row_height / 2), img_close,
			function () {
			plman.RemovePlaylist(id);
			RefreshPlaylists();
			SetSlider();
			GetCoordinates();
		}, "Remove");

	this.Draw = function (gr) {

		var item_move = 0;
		if (dragitem) {
			if (this.y + Y_OFFSET + this.height > mouse_y && this.id < dragitem.id) {
				item_move = dragitem.height + itemspace;
			}
			if (this.y + Y_OFFSET < mouse_y && this.id > dragitem.id) {
				item_move = -1 * (dragitem.height + itemspace);
			}
		}

		/*
		if (fb.IsPlaying && this.id == plman.PlayingPlaylist) {
		gr.FillSolidRect(this.x, this.y + item_move + Y_OFFSET, this.width, this.height, this.state == 0 ? item_playing_normal_color : (this.state == 1 ? item_playing_hover_color : item_playing_down_color));
		gr.GdiDrawText(this.name + " ", this.id == plman.ActivePlaylist ? text_font_selected : text_font_playing, this.state == 0 ? text_normal_color : (this.state == 1 ? text_hover_color : text_down_color), this.x + 50, this.y + item_move + Y_OFFSET, this.width - row_height / 2 - 80, this.height, DT_LEFT | DT_VCENTER | DT_END_ELLIPSIS | DT_SINGLELINE);
		}
		 */

		min_font = gdi.Font("Segoe UI", 12);

		if (this.id == plman.ActivePlaylist) {
			gr.FillSolidRect(this.x, this.y + item_move + Y_OFFSET, this.width, this.height, g_select_bg_col);
			gr.GdiDrawText(this.name + " ", text_font, g_select_txt_col, this.x + 50, this.y + item_move + Y_OFFSET - 10, this.width - row_height / 2 - 60, this.height, DT_LEFT | DT_VCENTER | DT_END_ELLIPSIS | DT_SINGLELINE);
			gr.GdiDrawText(this.count, min_font, g_select_txt_col, this.x + 50, this.y + item_move + Y_OFFSET + 10, this.width - row_height / 2 - 50, this.height, DT_LEFT | DT_VCENTER | DT_END_ELLIPSIS | DT_SINGLELINE);
		} else if (fb.IsPlaying && this.id == plman.PlayingPlaylist) {
			gr.FillSolidRect(this.x, this.y + item_move + Y_OFFSET, this.width, this.height, this.state == 0 ? RGBA(0, 0, 0, 5) : (this.state == 1 ? item_hover_color : item_selected_color));
			gr.GdiDrawText(this.name + " ", text_font, g_textcolor_2, this.x + 50, this.y + item_move + Y_OFFSET - 10, this.width - row_height / 2 - 60, this.height, DT_LEFT | DT_VCENTER | DT_END_ELLIPSIS | DT_SINGLELINE);
			gr.GdiDrawText(this.count, min_font, g_textcolor_2, this.x + 50, this.y + item_move + Y_OFFSET + 10, this.width - row_height / 2 - 50, this.height, DT_LEFT | DT_VCENTER | DT_END_ELLIPSIS | DT_SINGLELINE);
		} else {
			gr.FillSolidRect(this.x, this.y + item_move + Y_OFFSET, this.width, this.height, this.state == 0 ? item_normal_color : (this.state == 1 ? item_hover_color : item_selected_color));
			gr.GdiDrawText(this.name + " ", text_font, g_textcolor_2, this.x + 50, this.y + item_move + Y_OFFSET - 10, this.width - row_height / 2 - 60, this.height, DT_LEFT | DT_VCENTER | DT_END_ELLIPSIS | DT_SINGLELINE);
			gr.GdiDrawText(this.count, min_font, g_textcolor_2, this.x + 50, this.y + item_move + Y_OFFSET + 10, this.width - row_height / 2 - 50, this.height, DT_LEFT | DT_VCENTER | DT_END_ELLIPSIS | DT_SINGLELINE);
		}

		this.state == 1 && this.closebtn.Draw(this.closebtn.x, this.closebtn.y + item_move + Y_OFFSET + 3, gr);

		// draw stripes for the empty rows
		/*
		var parity = ((this.id / 2) == Math.floor(this.id / 2) ? 1 : 0);
		if (parity == 1)
		gr.FillSolidRect(this.x, this.y + item_move + Y_OFFSET, this.width, this.height, RGBA(0, 0, 0, 0));
		 */

		if (plman.IsAutoPlaylist(this.id)) {
			PlaylistIcon = (this.id == plman.ActivePlaylist ? AutoPlaylist_select_img : AutoPlaylist_img); // A PL
			//PausedPlaylistIcon = (this.id == plman.ActivePlaylist ? AutoPlaylist_paused_select_img : AutoPlaylist_paused_img);
		} else {
			PlaylistIcon = (this.id == plman.ActivePlaylist ? Playlist_select_img : Playlist_img);
			//PausedPlaylistIcon = (this.id == plman.ActivePlaylist ? Playlist_paused_select_img : Playlist_paused_img);
		}
		PlaylistIcon && gr.DrawImage(PlaylistIcon, this.x, this.y + Math.round(this.height / 2) - 23 + item_move + Y_OFFSET, PlaylistIcon.Width, PlaylistIcon.Height, 0, 0, PlaylistIcon.Width, PlaylistIcon.Height);

	}

	this.ChangeState = function (s) {
		this.state = s;
		window.RepaintRect(this.x, this.y + Y_OFFSET, this.width, this.height);
	}

	this.isXYok = function (x, y) {
		return ((y > this.y + Y_OFFSET && y < this.y + Y_OFFSET + this.height && x > this.x && x < this.width + this.x) ? true : false);
	}

	this.OnClick = function () {
		if (destination > -1) {
			plman.ActivePlaylist = this.id;
			plman.MovePlaylist(this.id, destination);
			RefreshPlaylists();
			window.Repaint();
			destination = -1;
			return;
		}
		plman.ActivePlaylist = this.id;
		RefreshPlaylists();
		window.Repaint();
	}
}

function RefreshPlaylists() {
	Items.splice(0, Items.length);
	sum_height = 0;
	for (var i = 0; i < plman.PlaylistCount; i++) {
		Items[i] = new Item(lm, tm + i * (itemspace + row_height), NeedScrollbar ? ww - lm - rm - scrollW : ww - lm - rm, row_height, plman.GetPlaylistName(i), plman.PlaylistItemCount(i), i);
		Items[i].closebtn.x = Items[i].x + Items[i].width - 30;
		sum_height += itemspace + row_height;
	}
	if (Items.length == 0) {
		DefaultTextItem = new Item(lm + 5, 50, ww - lm - rm, text_font_big.height * 3 + 12, "", "", "defaulttext");
		DefaultTextItem.show = true;
		DefaultTextItem.Draw = function (gr) {
			if (!this.show)
				return;
			gr.GdiDrawText("޲б\nﴴһб\nק", text_font_big, blendColors(g_textcolor, g_backcolor, 0.6), this.x, this.y, this.width, wh, DT_CENTER | DT_TOP | DT_CALCRECT | DT_NOPREFIX);
		}
		DefaultTextItem.OnClick = function () {
			plman.CreatePlaylist(Items.length, "");
			RefreshPlaylists();
			GetCoordinates();
			this.show = false;
		}
		Items[0] = DefaultTextItem;
		sum_height += 50 + text_font_big.height * 2 + 20;
	}
}

//timers {{

function c_ButtonAnimationTimer() {
	this.Stop = function () {
		if (ButtonAnimationTimerID) {
			window.ClearInterval(ButtonAnimationTimerID);
			ButtonAnimationTimerID = null;
		}
	}

	this.Start = function () {
		ButtonAnimationTimerID = window.SetInterval(function () {
				var NeedRepaint = 0;
				for (var i = 0; i < Items.length; i++) {
					if (Items[i].closebtn.NeedRefresh) {
						Items[i].closebtn.RefreshOpacity();
						NeedRepaint += 1;
						Onlybtn = Items[i].closebtn; // If only one button need to be repainted.
					}
				}

				if (NeedRepaint) {
					if (NeedRepaint == 1) {
						window.RepaintRect(Onlybtn.x, Onlybtn.y + Y_OFFSET, Onlybtn.width, Onlybtn.height);
					} else
						window.RepaintRect(MaxRange.x, MaxRange.y, MaxRange.width, MaxRange.height); // This is range of buttons.
				} else {
					ButtonAnimationTimer.Stop();
				}
			}, 50)
	}
}

function c_ScrollTimer() {
	this.Stop = function () {
		if (ScrollTimerID) {
			window.ClearInterval(ScrollTimerID);
			ScrollTimerID = null;
		}
	}

	this.Start = function () {
		ScrollTimerID = window.SetInterval(function () {
				if (mouse_y >= (row_height + itemspace) * 1 && direction == "up") {
					ScrollTimer.Stop();
				}
				if (mouse_y <= wh - (row_height + itemspace) * 1 && direction == "down") {
					ScrollTimer.Stop();
				}

				if (direction == "up")
					Y_OFFSET += 5;
				else if (direction == "down")
					Y_OFFSET -= 5;

				if (dragitem) {
					dragitem.y = Math.round(Math.min(Math.max(mouse_y - dragitem_y_rel - Y_OFFSET, 0), 99999));
					dragitem.closebtn.y = dragitem.y + row_height / 4;
				}
				SetSlider();
				window.Repaint();

				if (Y_OFFSET >= 0) {
					Y_OFFSET = 0;
					ScrollTimer.Stop();
				} else if (Y_OFFSET <= -1 * scrollmax) {
					Y_OFFSET = -1 * scrollmax;
					ScrollTimer.Stop();
				}
			}, 10)
	}
}

//timers }}

function SetSlider() {

	if (sum_height + tm < wh) {

		if (Y_OFFSET != 0) {
			Y_OFFSET = 0;
		}
		NeedScrollbar = false;
		return;
	} else {
		NeedScrollbar = true;
		scrollmax = sum_height + tm + row_height - wh;
		scrollpos = -1 * Y_OFFSET;

		ratio = wh / (sum_height + tm + row_height); // page height / summary height
		if (ratio > 1)
			ratio = 1;

		Scrollbar.step = 1 / ratio;
		Scrollbar.slider.height = Math.round(ratio * wh);
		if (Scrollbar.slider.height < Scrollbar.min_height) {
			Scrollbar.slider.height = Scrollbar.min_height;
		}

		Scrollbar.slider.y = Math.round((wh - Scrollbar.slider.height) * scrollpos / scrollmax);

		Scrollbar.slider.x = ww - scrollW;
		Scrollbar.slider.width = scrollW;

		if (Y_OFFSET < -1 * (sum_height - wh + tm + row_height)) {
			Y_OFFSET = -1 * (sum_height - wh + tm + row_height);
		}
	}
}

function V_SCROLLBAR(width, min_h) {
	this.width = width;
	this.step = 0;
	this.state = 0;
	this.slider = {
		x : 0,
		y : 0,
		width : 0,
		height : 0,
		min_height : min_h
	}

	this.isXYok = function (x, y) {
		return (x >= this.x && y >= this.y && x <= this.x + this.width && y <= this.y + this.height) ? true : false;
	}

	this.slider_isXYok = function (x, y) {
		return (x >= this.slider.x && y >= this.slider.y && x <= this.slider.x + this.slider.width && y <= this.slider.y + this.slider.height) ? true : false;
	}

	this.Draw = function (gr) {
		if (NeedScrollbar) {
			gr.FillSolidRect(this.slider.x + 2, this.slider.y + 2, this.slider.width - 4, this.slider.height - 4, (slider_drag) ? vs_down_color : (slider_hover ? vs_hover_color : vs_normal_color));
		}
	}

}

function playlist_context_menu(x, y, id, pl_hover) {

	var _menu = window.CreatePopupMenu();
	var c = window.CreatePopupMenu();
	var sw_tp = window.CreatePopupMenu();
	var Context = fb.CreateContextMenuManager();
	var metadblist_selection = plman.GetPlaylistItems(id);
	var pr = window.CreatePopupMenu();
	var prm = plman.PlaylistRecyclerManager;
	var idx;

	pl_hover && _menu.AppendMenuItem(MF_STRING, 804, "б");
	pl_hover && _menu.AppendMenuItem(MF_SEPARATOR, 0, 0);
	pl_hover && _menu.AppendMenuItem(MF_STRING, 805, "б");
	pl_hover && _menu.AppendMenuItem(MF_STRING, 824, "ɾб");
	pl_hover && _menu.AppendMenuItem(MF_SEPARATOR, 0, 0);
	pl_hover && _menu.AppendMenuItem(MF_STRING, 822, "Ʋб");
	pl_hover && _menu.AppendMenuItem(MF_SEPARATOR, 0, 0);
	_menu.AppendMenuItem(MF_STRING, 801, "½б");
	_menu.AppendMenuItem(MF_STRING, 802, "½Զб");
	_menu.AppendMenuItem(MF_SEPARATOR, 0, 0);

	if (pl_hover && plman.IsAutoPlaylist(id)) {
		_menu.AppendMenuItem(MF_STRING, 821, "תΪͨб");
		_menu.AppendMenuItem(MF_STRING, 820, "Զб ...");
		_menu.AppendMenuItem(MF_SEPARATOR, 0, 0);

	}

	pl_hover && _menu.AppendMenuItem(MF_STRING, 830, "ȫб...");
	pl_hover && _menu.AppendMenuItem(MF_STRING, 823, "沥б...");
	_menu.AppendMenuItem(MF_STRING, 831, "벥б...");
	!pl_hover && _menu.AppendMenuItem(MF_SEPARATOR, 0, 0);

	pr.AppendTo(_menu, prm.Count >= 1 ? MF_STRING : MF_GRAYED | MF_DISABLED, "ָ");
	if (prm.Count >= 1) {
		for (var irm = 0; irm < prm.Count; irm++) {
			pr.AppendMenuItem(MF_STRING, 2001 + irm, prm.Name(irm));
		}
		pr.AppendMenuItem(MF_SEPARATOR, 0, 0);
		pr.AppendMenuItem(MF_STRING, 2000, "ʷ");
	}

	pl_hover && (plman.PlaylistItemCount(id) >= 1) && _menu.AppendMenuItem(MF_SEPARATOR, 0, 0);
	pl_hover && (plman.PlaylistItemCount(id) >= 2) && sw_tp.AppendTo(_menu, 0, "");
	sw_tp.AppendMenuItem(MF_STRING, 951, "...");
	sw_tp.AppendMenuItem(MF_STRING, 952, "");
	sw_tp.AppendMenuItem(MF_STRING, 953, "ߵ");
	sw_tp.AppendMenuItem(MF_STRING, 954, "ר");
	sw_tp.AppendMenuItem(MF_STRING, 955, "");
	sw_tp.AppendMenuItem(MF_STRING, 962, "");
	sw_tp.AppendMenuItem(MF_STRING, 960, "");
	sw_tp.AppendMenuItem(MF_STRING, 963, "ʱ");
	sw_tp.AppendMenuItem(MF_STRING, 956, "ļ·");
	sw_tp.AppendMenuItem(MF_STRING, 964, "ļС");
	sw_tp.AppendMenuItem(MF_STRING, 961, "");
	sw_tp.AppendMenuItem(MF_STRING, 959, "Ŵ");
	sw_tp.AppendMenuItem(MF_STRING, 957, "");
	sw_tp.AppendMenuItem(MF_STRING, 958, "");

	pl_hover && (plman.PlaylistItemCount(id) >= 1) && c.AppendTo(_menu, 0, '"' + plman.GetPlaylistName(id) + '" Ĳ˵');
	Context.InitContext(metadblist_selection);
	Context.BuildMenu(c, 1, -1);

	idx = _menu.TrackPopupMenu(x, y);
	if (idx < 800) {
		Context.ExecuteByID(idx - 1);
	} else if (idx < 1000) {
		switch (idx) {
		case 801:
			plman.CreatePlaylist(plman.PlaylistCount, "½б #" + (plman.PlaylistCount + 1));
			RefreshPlaylists();
			GetCoordinates();
			break;
		case 802:
			plman.ActivePlaylist = plman.CreateAutoPlaylist(plman.PlaylistCount, "½б #" + (plman.PlaylistCount + 1), "");
			RenamePL(plman.ActivePlaylist);
			plman.ShowAutoPlaylistUI(plman.ActivePlaylist);
			break;
		case 804:
			plman.ActivePlaylist = id;
			break;
		case 805:
			RenamePL(id);
			break;
		case 810:
			break;
		case 820:
			plman.ShowAutoPlaylistUI(id);
			break;
		case 821:
			plman.DuplicatePlaylist(id, plman.GetPlaylistName(id));
			plman.RemovePlaylist(id);
			plman.ActivePlaylist = id;
			break;
		case 822:
			plman.DuplicatePlaylist(plman.ActivePlaylist, plman.GetPlaylistName(plman.ActivePlaylist));
			plman.ActivePlaylist = plman.ActivePlaylist + 1;
			break;
		case 823:
			fb.RunMainMenuCommand("ļ/沥б...");
			break;
		case 824:
			plman.RemovePlaylist(id);
			break;
		case 830:
			fb.RunMainMenuCommand("ļ/вб...");
			break;
		case 831:
			fb.RunMainMenuCommand("ļ/벥б...");
			break;
		case 951:
			fb.RunMainMenuCommand("༭//...");
			break;
		case 952:
			fb.RunMainMenuCommand("༭//");
			break;
		case 953:
			fb.RunMainMenuCommand("༭//ߵ");
			break;
		case 954:
			fb.RunMainMenuCommand("༭//ר");
			break;
		case 955:
			fb.RunMainMenuCommand("༭//");
			break;
		case 956:
			fb.RunMainMenuCommand("༭//ļ·");
			break;
		case 957:
			fb.RunMainMenuCommand("༭//򰴱");
			break;
		case 958:
			fb.RunMainMenuCommand("༭//");
			break;
		case 959:
			plman.SortByFormat(plman.ActivePlaylist, "%play_count%", false);
			fb.RunMainMenuCommand("༭//ߵ");
			break;
		case 960:
			plman.SortByFormat(plman.ActivePlaylist, "%date%", false);
			break;
		case 961:
			plman.SortByFormat(plman.ActivePlaylist, "%genre%", false);
			break;
		case 962:
			plman.SortByFormat(plman.ActivePlaylist, "%bitrate%", false);
			fb.RunMainMenuCommand("༭//ߵ");
			break;
		case 963:
			plman.SortByFormat(plman.ActivePlaylist, "%length%", false);
			break;
		case 964:
			plman.SortByFormat(plman.ActivePlaylist, "%filesize%", false);
			break;
		}
	}

	if (idx >= 2000) {
		switch (idx) {
		case 2000:
			var affectedItems = Array();
			for (var i = 0; i < prm.Count; i++) {
				affectedItems.push(i);
			}
			prm.Purge(affectedItems);
			break;
		default:
			(prm.Count >= 1) && prm.Restore(idx - 2001);
		}
	}

	_menu.Dispose();
	pr.Dispose();
	sw_tp.Dispose();
	c.Dispose();

	return true;
}
